<?php


add_action( 'wp_enqueue_scripts', 'twx_custom_styles_pro' );
function twx_custom_styles_pro( $customizer_style ) {
	
	/*--- All customizer pro options styles ---*/
	
	//Background color
	$primary_color = get_theme_mod( 'primary_color', '#943A4D' );
	$customizer_style .= '.nav-cart .cart-count, .twx-latest-news.style2 .posted-on, .roll-button { background-color: ' . $primary_color . ' }';
	
	$customizer_style .= ' .star-rating:before, .woocommerce p.stars a:hover:after, .woocommerce p.stars a.active:after, .roll-button:hover { color: ' . $primary_color . ' }';
	
	$customizer_style .= '.single-product .woocommerce-tabs ul.tabs li.active a, .roll-button { border-color: ' . $primary_color . ' }';
	
	//top_menu_size
	$cart_top_value = get_theme_mod( 'top_menu_size', '15' );
	$customizer_style .= '.nav-cart .cart-count { top: calc( -' . esc_attr( $cart_top_value ) . 'px - 8px ); } ';
	

	
	//Body font family and font size
	$body_font_family = get_theme_mod( 'body_font_family' );
	$body_font_size = get_theme_mod( 'body_font_size', '16' );
	$customizer_style .= 'body { font-family: ' . $body_font_family . '; font-size: ' . $body_font_size . 'px; } ';
	
	//Title font family  
	$title_font_family = get_theme_mod( 'title_font_family' );
	$customizer_style .= 'h1, h2, h3, h4, h5, h6 { font-family: ' . $title_font_family . '; } ';
	
	//h1 font size
	$h1_font_size = get_theme_mod( 'h1_font_size', '50' );
	$customizer_style .= 'h1 { font-size: ' . $h1_font_size . 'px; } ';
	
	//h2 font size
	$h2_font_size = get_theme_mod( 'h2_font_size', '42' );
	$customizer_style .= 'h2 { font-size: ' . $h2_font_size . 'px; } ';
	
	//h3 font size
	$h3_font_size = get_theme_mod( 'h3_font_size', '32' );
	$customizer_style .= 'h3 { font-size: ' . $h3_font_size . 'px; } ';
	
	//h4 font size
	$h4_font_size = get_theme_mod( 'h4_font_size', '25' );
	$customizer_style .= 'h4 { font-size: ' . $h4_font_size . 'px; } ';
	
	//h5 font size
	$h5_font_size = get_theme_mod( 'h5_font_size', '20' );
	$customizer_style .= 'h5 { font-size: ' . $h5_font_size . 'px; } ';
	
	//h6 font size
	$h6_font_size = get_theme_mod( 'h6_font_size', '18' );
	$customizer_style .= 'h6 { font-size: ' . $h6_font_size . 'px; } ';
	
	//h1 title color
	$h1_title_color = get_theme_mod( 'h1_title_color', '' );
	$customizer_style .= 'h1 { color: ' . $h1_title_color . '; } ';
	
	//h2 title color
	$h2_title_color = get_theme_mod( 'h2_title_color', '' );
	$customizer_style .= 'h2 { color: ' . $h2_title_color . '; } ';
	
	//h3 title color
	$h3_title_color = get_theme_mod( 'h3_title_color', '' );
	$customizer_style .= 'h3 { color: ' . $h3_title_color . '; } ';
	
	//h4 title color
	$h4_title_color = get_theme_mod( 'h4_title_color', '' );
	$customizer_style .= 'h4 { color: ' . $h4_title_color . '; } ';
	
	//h5 title color
	$h5_title_color = get_theme_mod( 'h5_title_color', '' );
	$customizer_style .= 'h5 { color: ' . $h5_title_color . '; } ';
	
	//h6 title color
	$h6_title_color = get_theme_mod( 'h6_title_color', '' );
	$customizer_style .= 'h6 { color: ' . $h6_title_color . '; } ';
	
	//Wc widgets position
	if(get_theme_mod('wc_widgets_pos')){
		$wc_widgets_pos = get_theme_mod('wc_widgets_pos', 'right');
		( $wc_widgets_pos = 'right' ? $wc_widgets_pos = 'left' : $wc_widgets_pos = 'right' );
		$customizer_style .= ".woocommerce .content-area, .woocommerce-cart .content-area, .woocommerce-checkout .content-area {float: ". $wc_widgets_pos .";}";
	}
	
	//Site title size
	$site_title_size = get_theme_mod( 'site_title_size', '30' );
	$customizer_style .= '.site-title a { font-size: ' . esc_attr( $site_title_size ) . 'px; } ';
	
	//Tagline size
	$tagline_size = get_theme_mod( 'tagline_size', '15' );
	$customizer_style .= '.site-description { font-size: ' . esc_attr($tagline_size) . 'px; } ';
	
	//Top menu  color
	$top_menu_color = get_theme_mod( 'top_menu_color', '#ffffff' );
	$customizer_style .= '#site-navigation ul li a { color: ' . esc_attr($top_menu_color) . '; } ';
	
	//Top menu background color
	$top_menu_bg_color = get_theme_mod( 'top_menu_bg_color', '' );
	$customizer_style .= '#site-navigation ul li{ background-color: ' . esc_attr($top_menu_bg_color) . '; } ';
	
	//Top menu font-size
	$top_menu_size = get_theme_mod( 'top_menu_size', '15' );
	$customizer_style .= '#site-navigation ul li a{ font-size: ' . esc_attr($top_menu_size) . 'px; } ';
	
	
	//sub menu  color
	$sub_menu_color = get_theme_mod( 'sub_menu_color', '#ffffff' );
	$customizer_style .= '#site-navigation ul ul li a { color: ' . esc_attr($sub_menu_color) . '; } ';
	
	//sub menu background color
	$sub_menu_bg_color = get_theme_mod( 'sub_menu_bg_color', '#333333' );
	$customizer_style .= '#site-navigation ul ul li a{ background-color: ' . esc_attr($sub_menu_bg_color) . '; } ';
	
	//sub menu font-size
	$sub_menu_size = get_theme_mod( 'sub_menu_size', '15' );
	$customizer_style .= '#site-navigation ul ul li a{ font-size: ' . esc_attr($sub_menu_size) . 'px; } ';
	
	//menu hover color
	$menu_hover_color = get_theme_mod( 'menu_hover_color', '#943A4D' );
	$customizer_style .= '#site-navigation ul li a:hover{ color: ' . esc_attr($menu_hover_color) . '; } ';
	
	//sub menu hover color
	$Sub_menu_hover_color = get_theme_mod( 'Sub_menu_hover_color', '#ffffff' );
	$customizer_style .= '#site-navigation .sub-menu li > a:hover{ color: ' . esc_attr($Sub_menu_hover_color) . '; } ';
	
	//sub menu background hover color
	$Sub_menu_bg_hover_color = get_theme_mod( 'Sub_menu_bg_hover_color', '#CF3141' );
	$customizer_style .= '#site-navigation .sub-menu li:hover > a{ background-color: ' . esc_attr($Sub_menu_bg_hover_color) . '; } ';
	
	//sub menu background hover color
	$header_top_background = get_theme_mod( 'header_top_background', '#09090B' );
	$header_top_background = twx_hex2rgba($header_top_background, 0.9);
	//( empty($header_top_background) ? $set_header_bg = $primary_color : $set_header_bg = $primary_color )
	$customizer_style .= '.site-header.sticky{ background-color: ' . esc_attr($header_top_background) . '; } ';
	
	//Top contact background color
	$contact_bg_color = get_theme_mod( 'contact_bg_color', '#943A4D' );
	$customizer_style .= '.header-contact{ background-color: ' . esc_attr($contact_bg_color) . '; } ';
	
	//Top contact text color
	$contact_text_color = get_theme_mod( 'contact_text_color', '#ffffff' );
	$customizer_style .= '.header-contact, .header-contact a{ color: ' . esc_attr($contact_text_color) . '; } ';
	
	//Button background color
	$btn_bg_color = get_theme_mod( 'btn_bg_color', '' );
	$customizer_style .= '.banner-button, button, input[type="submit"], input[type="button"], input[type="reset"] { background-color: ' . esc_attr($btn_bg_color) . '; border-color: ' . esc_attr($btn_bg_color) . '; } ';
	
	//Button text color
	$btn_text_color = get_theme_mod( 'btn_text_color', '' );
	$customizer_style .= '.banner-button, button, input[type="submit"], input[type="button"], input[type="reset"] {color: ' . esc_attr($btn_text_color) . ';} ';
	
	//Button hover background color
	$btn_hover_bg_color = get_theme_mod( 'btn_hover_bg_color', '' );
	$customizer_style .= '.banner-button:hover, button:hover, input[type="submit"]:hover, input[type="button"]:hover, input[type="reset"]:hover { background-color: ' . esc_attr($btn_hover_bg_color) . '; border-color: ' . esc_attr($btn_hover_bg_color) . '; } ';
	
	//Button hover text color
	$btn_hover_text_color = get_theme_mod( 'btn_hover_text_color', '' );
	$customizer_style .= '.banner-button:hover, button:hover, input[type="submit"]:hover, input[type="button"]:hover, input[type="reset"]:hover {color: ' . esc_attr($btn_hover_text_color) . ';} ';
	
	//Button top and bottom padding
	$tb_btn_padding = get_theme_mod( 'tb_btn_padding', '15' );
	//Button left and right padding
	$lr_btn_padding = get_theme_mod( 'lr_btn_padding', '30' );
	$customizer_style .= '.banner-button, button, input[type="submit"], input[type="button"], input[type="reset"] {padding: ' . esc_attr($tb_btn_padding).'px '.esc_attr($lr_btn_padding) . 'px;} ';

	//Button border radius
	$btn_border_radius = get_theme_mod( 'btn_border_radius', '3' );
	$customizer_style .= '.banner-button, button, input[type="submit"], input[type="button"], input[type="reset"] {border-radius: ' . esc_attr($btn_border_radius).'px;} ';
	
	
	
	//footer widgets background color
	$widget_area_bg = get_theme_mod( 'widget_area_bg', '' );
	$customizer_style .= '.footer-widgets {background-color: ' . esc_attr($widget_area_bg).';} ';
	
	//footer widgets text color
	$widget_area_color = get_theme_mod( 'widget_area_color', '' );
	$customizer_style .= '.footer-widgets {color: ' . esc_attr($widget_area_color).';} ';
	
	//footer  background color
	$main_footer_bg = get_theme_mod( 'main_footer_bg', '' );
	$customizer_style .= '.site-footer {background-color: ' . esc_attr($main_footer_bg).';} ';
	
	//footer  text color
	$main_footer_color = get_theme_mod( 'main_footer_color', '' );
	$customizer_style .= '.site-footer {color: ' . esc_attr($main_footer_color).';} ';
	
	//other header banner image
	$other_bg_img = get_theme_mod( 'other_bg_img', get_stylesheet_directory_uri() . '/images/banner1.jpg' );
	$customizer_style .= '.other-header {background: url('.$other_bg_img.');} ';

	//other header banner height
	$other_banner_height = get_theme_mod( 'other_banner_height', '350' );
	$customizer_style .= '.other-header {height :'.esc_attr($other_banner_height).'px;} ';
	
	//banner slider height
	$slider_height = get_theme_mod( 'slider_height', '700' );
	$customizer_style .= '#banner-slider .item img.back {height :'.esc_attr($slider_height).'px;} ';

	
	
	/*--- Apply all the customizer pro styles ---*/
	
	if( $customizer_style ){
		wp_add_inline_style( 'customizer-style', $customizer_style );
	}
	
	
}